"use strict";
/**
 * ANSI color codes and icons for terminal output
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.box = exports.icons = exports.colors = void 0;
// ANSI color codes
exports.colors = {
    reset: "\x1b[0m",
    bold: "\x1b[1m",
    dim: "\x1b[2m",
    italic: "\x1b[3m",
    underline: "\x1b[4m",
    // Foreground colors
    black: "\x1b[30m",
    red: "\x1b[31m",
    green: "\x1b[32m",
    yellow: "\x1b[33m",
    blue: "\x1b[34m",
    magenta: "\x1b[35m",
    cyan: "\x1b[36m",
    white: "\x1b[37m",
    gray: "\x1b[90m",
    // Bright colors
    brightRed: "\x1b[91m",
    brightGreen: "\x1b[92m",
    brightYellow: "\x1b[93m",
    brightBlue: "\x1b[94m",
    brightMagenta: "\x1b[95m",
    brightCyan: "\x1b[96m",
    brightWhite: "\x1b[97m",
};
// Icons for different log types
exports.icons = {
    success: "✓",
    error: "✗",
    warning: "⚠",
    info: "ℹ",
    debug: "●",
    arrow: "→",
    bullet: "•",
    star: "★",
    check: "✔",
    cross: "✖",
    rocket: "🚀",
    database: "◆",
    server: "◈",
    cron: "⏱",
    extension: "◇",
    route: "⤷",
    time: "◷",
};
// Box drawing characters
exports.box = {
    topLeft: "╭",
    topRight: "╮",
    bottomLeft: "╰",
    bottomRight: "╯",
    horizontal: "─",
    vertical: "│",
    teeRight: "├",
    teeLeft: "┤",
    cross: "┼",
};
