"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.metadata = void 0;
const query_1 = require("@b/utils/query");
exports.metadata = {
    summary: "Bulk deletes Staking Pools by IDs",
    operationId: "bulkDeleteStakingPools",
    tags: ["Admin", "Staking", "Pools"],
    logModule: "ADMIN_STAKE",
    logTitle: "Bulk Delete Staking Pools",
    parameters: (0, query_1.commonBulkDeleteParams)("Staking Pools"),
    requestBody: {
        required: true,
        content: {
            "application/json": {
                schema: {
                    type: "object",
                    properties: {
                        ids: {
                            type: "array",
                            items: { type: "string" },
                            description: "Array of Staking Pool IDs to delete",
                        },
                    },
                    required: ["ids"],
                },
            },
        },
    },
    responses: (0, query_1.commonBulkDeleteResponses)("Staking Pools"),
    requiresAuth: true,
    permission: "edit.staking.pool",
};
exports.default = async (data) => {
    const { body, query } = data;
    const { ids } = body;
    return (0, query_1.handleBulkDelete)({
        model: "stakingPool",
        ids,
        query,
    });
};
